
## e.g.

```json5

{
  "validateColumns": [ // 必填，需要校验的非空列（1+）
    "age",
    "name"
  ],
  "selectColumns": [ // 核检结果错误数据输出列（选填，默认全部输出、也可以使用Excel单独的列编写）
    "sid",
    "age",
    "name"
  ],
  "allNonNull": true, // 所有校验的列全部不为空（单一列校验时此设置无效）
  "dataFilter": {} // 数据过滤器（可选，仅校验过滤后的数据）
}

```

## e.g.

```json5

{
  "validateColumn": "LAST_MODIFIED_TIME",
  "type" : "BETWEEN",  // 0-ENUM 枚举值（穷举）； 1-TABLE 值域来源于其他表的某个字段； 2-THRESHOLD 阈值（大于、大于等于、小于、小于等于）； 3-BETWEEN 值区间（between） 多用于数值和日期
  "patterns": [{
    // 规则参数多种格式
    // type=ENUM         e.g. [ "java", "python", "go", "js", "html", ... ] // 多值
    // type=TABLE        e.g. [ "字段名", "表名", "库名(可选，默认当前库)"] // 2 or 3 值 （这种类型可以使用有效数据检查模板）
    // type=THRESHOLD    e.g. [ 100 ] // 单值
    // type=BETWEEN      e.g. [ 100, 200 ] ; [ "2021-04-29 14:49:17", "2019-09-02 16:11:05" ] // 双值
    "values": [ "2021-04-29 14:49:17", "2019-09-02 16:11:05" ],
    "format": "datetime", // 可选，对于日期类型数据可以设置为 date(yyyy-MM-dd)/datetime(yyyy-MM-dd HH:mm:ss)/自定义格式化，配置为data或datetime情况下可以使用<Long>或<LongString>或<LongString+时间单位（d/h/m/s）>来编写值（建议还是使用日期格式化，其他格式UI未做兼容识别）
    // 规则参数辅助选项
    // type=THRESHOLD   0 大于等于/ge;  1 大于/gt; 2 小于等于/le; 3 小于/lt; 4 等于/eq（缺省值）
    // type=BETWEEN     5 开区间/all（缺省值）; 6 左开右闭/left; 7 左闭右开/right; 8 闭区间/none （开：包含；闭：不包含）
    "option" : "all"
  }], // 某个字段的合法值存在多个区间，可以写多个，如老人和儿童的年龄  [{ "values": [0, 12], "matchType": 5 }, { "values": [60, 150], "matchType": 5 }]
  "selectColumns": [ "sid" ,"code", "name" ], // 核检结果错误数据输出列（选填，默认全部输出、也可以使用Excel单独的列编写）
  "dataFilter": {} // 数据过滤器（可选，仅校验过滤后的数据）
}

```

## e.g.

```json5

{
  "validateColumn": "teacher_no",
  "values": [ "字段名", "表名", "库名(可选，默认当前库)"],
  "selectColumns": [ "sid" ,"code", "name" ], // 核检结果错误数据输出列（选填，默认全部输出、也可以使用Excel单独的列编写）
  "dataFilter": {} // 数据过滤器（可选，仅校验过滤后的数据）
}

```

## e.g.

```json5

{
  "validateColumn": "cid",
  "value": "id-card", // id-card <居民身份证>； mobile-number.cn <中国大陆移动电话号码>, ...
  "selectColumns": [ "sid" ,"code", "name" ], // 核检结果错误数据输出列（选填，默认全部输出、也可以使用Excel单独的列编写）
  "dataFilter": {} // 数据过滤器（可选，仅校验过滤后的数据）
}

```

## e.g.

```json5

{
  "validateColumns": // 唯一性约束列 (1+)
  [
    "name"
  ],
  "selectColumns": // 核检结果错误数据输出列（选填，默认全部输出、也可以使用Excel单独的列编写）
  [
    "sno",
    "age",
    "name"
  ],
  "dataFilter": {} // 数据过滤器（可选，仅校验过滤后的数据）
}
```

## e.g.

```json5

{
  "validateColumn": "created_at",
  "startTime": "2022-08-22 11:11:11",
  "endTime": 2,
  "endTimeUnit": "DAYS", // 可用枚举值： DAYS, HOURS, MINUTES （参考java.util.concurrent.TimeUnit）
  "selectColumns": [ // 核检结果错误数据输出列（选填，默认全部输出、也可以使用Excel单独的列编写）
    "age",
    "name",
    "created_at"
  ],
  "dataFilter": {} // 数据过滤器（可选，仅校验过滤后的数据）
}
```

## e.g.

```json5

{
  "validateColumn": "name", // 校验字段
  "refTable": "student_copy", // 对照表
  "refColumn": "name" // 对照字段
}

```

## e.g.

```json5
// 有注释的需要修改，其他部分保留
{
  "validateColumns": ["NAME"], //必填，需要检核的字段
  "sinkConfig": {
    "sinkFileConfig": null,
    "sinkAfcConfig": null,
    "sinkConnectionConfig": {
      "dsDataSourceSid": null,
      "dbName": null
    }
  },
  "alarm": {
    "weChat": {
      "robotKeys": []
    },
    "dingTalk": {
      "robotKeys": []
    },
    "email": {
      "addresses": []
    }
  },
  "validateSql": "select * FROM quality_test WHERE name is null", // 必填，查询有问题的数据
  "countSql": "select count(*) FROM quality_test" ,// 选填，扫描数据总数，一般使用count函数进行计算
  "ruleConfig": { //选填， 为了适配新版和老版适配
    "countSql": "select count(*) FROM quality_test",
    "validateSql": "select * FROM quality_test WHERE name is null"
  }
}
```

## e.g.

```json5

// 【注意】这一条不是检核规则类型，这条是数据过滤器报文参考 `${dataFilter}`
{
  "match": "and", // 逻辑运算符可以进行多级嵌套（and/or）
  "children": [{
    "column": "学年",
    "match": "eq",
    "value": [ 2022 ]
  }, {
    "column": "班级",
    "match": "in",
    "value": [ 220301, 220302, 220303, 220304 ]
  }]
}

//  支持的SQL匹配方式
//  eq # Default mather
//    ne
//
//    gt
//    ge
//    lt
//    le
//
//    like # SQL like pattern
//    contains
//    starts_with
//    ends_with
//    not_like # SQL like pattern
//    not_contains
//    not_starts_with
//    not_ends_with
//
//    between
//    not_between
//
//    in
//    not_in
//
//    is_null
//    not_null


// 也可以自己写过滤SQL片段（where后面的条件）
// { "match": "and", "value": [ "学年 = 2022 and 班级 in (220301, 220302, 220303, 220304)" ] }

```

