package com.primeton.eos.standalone.core.encoder;

import com.primeton.mdm.management.spi.code.Formatter;
import com.primeton.mdm.management.spi.code.StatelessEncoder;
import org.springframework.stereotype.Component;

import java.util.Map;
import java.util.UUID;

@Component("MDMCustomUUID7Encoder")
public class CustomUUIDv7Encoder implements StatelessEncoder<CustomUUIDv7Config>, Formatter<CustomUUIDv7Config> {

    @Override
    public String name() {
        return CustomUUIDv7Config.TYPE;
    }

    @Override
    public Class<CustomUUIDv7Config> type() {
        return CustomUUIDv7Config.class;
    }

    @Override
    public String generate(String model, CustomUUIDv7Config config, Map<String, Object> data) {
        String uuid = UUID.randomUUID().toString();
        uuid = config.isDelimiter() ? uuid : uuid.replace("-", "");
        uuid = config.isUppercase() ? uuid.toUpperCase() : uuid;
        int length = uuid.length();
        if (length > 0 && length < 32) {
            if (!config.isDelimiter()) {
                return format(config, uuid.substring(0, length));
            }
            for (int i = 0, j = 0; i < uuid.length(); i++) {
                if (j == length) {
                    return uuid.substring(0, i);
                }
                if (uuid.charAt(i) == '-') {
                    continue;
                }
                j++;
            }
        }
        return format(config, uuid);
    }
}
